/* ********************************************************************************
# If you should have any comments, suggestions or improvements to these samples, 
# we welcome you to contact us at SampleCode@melissadata.com also please visit our 
# developers bulletin board at forum.melissadata.com.
# ******************************************************************************** */

/* ********************* LICENSE STRINGS **********************
#*     To unlock the full functionality of Name Object,        *
#* please call a sales representative at 1-800-MELISSA ext. 3  *
#*         (1-800-635-4772 x3) for a license string.           *
#*  Name Object will not function without a valid              *
#*      			  license string 			          	   *
#************************************************************* */


set pagesize 2000;
set long 20000;
set echo off;
set pages 999;
set serveroutput off;

truncate table log;
commit;

declare
  no pls_integer;
  bno varchar2(100);
  val varchar2(32767);
  ok integer;
begin

  insert into log values('starting');
  commit;

  no :=  mdNameCreate();
  insert into log values('created mdName object');
  commit;

  ok := mdNameSetLicenseString(no, 'SET_LICENSE_HERE');
  insert into log values('set license: ok=' || ok);
  commit;

  bno := mdNameGetBuildNumber(no);
  insert into log values('build number= ' || bno);
  commit;

  mdNameSetPathToNameFiles(no, 'SET_PATH_HERE');
  insert into log values('set path to Email files');
  commit;

  ok := mdNameInitializeDataFiles(no);
  insert into log values('init datafiles: error=' || ok);
  commit;

  val := mdNameGetDatabaseDate(no);
  insert into log values('database date = ' || val);
  commit;

  val := mdNameGetLicenseExpirationDate(no);
  insert into log values('license date = ' || val);
  commit;

  val := mdNameGetDatabaseExpDate(no);
  insert into log values('exp date = ' || val);
  commit;

  ok := mdNameSetPrimaryNameHint(no, 1);
  insert into log values('setprimarynamehint = T');
  commit;

  mdNameSetSalutationSlug(no, 'Dear');
  insert into log values('setprimarynamehint = set');
  commit;

  mdNameSetFullName(no, 'Mr. Bud M Walker III');
  insert into log values('setfullname = set');
  commit;

  ok := mdNameParse(no);
  insert into log values('nameparse, ok=' || ok);
  commit;

  val := mdNameGetStatusCode(no);
  insert into log values('status=' || val);
  commit;

  val := mdNameGetErrorCode(no);
  insert into log values('err=   ' || val);
  commit;

  val := mdNameGetPrefix(no);
  insert into log values('name prefix=  ' || val);
  commit;

  val := mdNameGetFirstName(no);
  insert into log values('first name=  ' || val);
  commit;

  val := mdNameGetMiddleName(no);
  insert into log values('middle name=  ' || val);
  commit;

  val := mdNameGetLastName(no);
  insert into log values('last name=  ' || val);
  commit;

  val := mdNameGetSuffix(no);
  insert into log values('name suffix=  ' || val);
  commit;

  val := mdNameGetResults(no);
  insert into log values('result= ' || val);
  commit;

  mdNameDestroy(no);
  insert into log values('destroyed mdName object');
  commit;

end;
.
run

select * from log;
